/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigDigester;
import com.ibm.hwmca.ui.bonsai.config.WuiConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.servlet.Action;
import com.ibm.hwmca.ui.bonsai.servlet.util.ActionUtils;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorManager;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.page.PageException;
import com.ibm.psw.wcl.core.page.PageManager;
import com.ibm.psw.wcl.core.renderer.DefaultRendererFactory;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.RendererInfo;
import com.ibm.psw.wcl.core.renderer.output.IDocumentOutput;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.skin.DefaultSkinManager;
import com.ibm.psw.wcl.core.trigger.IResult;
import com.ibm.psw.wcl.core.trigger.RequestNotHandledException;
import com.ibm.psw.wcl.core.trigger.TriggerException;
import com.ibm.psw.wcl.tags.core.WJspPage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ControllerServlet
extends HttpServlet {
    static final long serialVersionUID = -5332287525923253726L;
    private HashMap _actions;
    private WuiConfigBean configBean_ = null;
    private static UIObjectsReader uiObjectsReader = null;
    public static final String FACADE_ID_ATTRIBUTE = "hmc.bonsai.facadeid";
    public static final String CONTEXT_ATTRIBUTE = "contextpath";
    public static final String ACTIONCLASSES_ID_ATTRIBUTE = "actionclasses";
    private static final String SKIN_MANAGER_ID = "hmc.bonsai.skinManager";
    private static final String TRIGGER_MANAGER_ID = "hmc.bonsai.triggerManager";
    private static final String TRIGGER_MANAGER_PATH = "/bonsai/action/";
    private static final String FRAMERELOAD_MANAGER_ID = "hmc.bonsai.frameReloadManager";
    private static final String RENDERER_FACTORY_ID = "hmc.bonsai.renderFactory";
    private static final String RESOURCE_LOADER_MANAGER_ID = "hmc.bonsai.resourceLoaderManager";
    private static final String PAGE_MANAGER_ID = "hmc.bonsai.pageManager";
    private static final String VR = "1.0";
    private static final String TRACE_MASKT = "XBUICTLT";
    private static final String TRACE_MASKF = "XBUICTLF";
    private static final String TRACE_MASKD = "XBUICTLD";

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.createGlobalObjects();
            this.initActionClasses(config);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
            throw new ServletException("Error initializing the web application.", (Throwable)e);
        }
    }

    public final void destroy() {
        super.destroy();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Trace.trace(TRACE_MASKT, "-> ControllerServlet.doGet()");
        try {
            ServletRuntime.getRuntime().attachUserContextToServletThread(request);
            HttpSession session = request.getSession(true);
            HMCSession hmcSession = HMCSession.getHMCSession(request.getSession());
            if (hmcSession == null) {
                throw new IllegalStateException("No HMC Session");
            }
            UserObject userObj = null;
            Object object = session;
            synchronized (object) {
                userObj = UserObject.getUserObject(hmcSession);
                if (userObj == null) {
                    try {
                        userObj = new UserObject();
                        userObj.init(hmcSession);
                    }
                    catch (Exception ex) {
                        throw new ServletException("Could not initialize UserObject! " + ex.toString());
                    }
                }
            }
            object = userObj.getRequestLock();
            synchronized (object) {
                WclFacade facade = this.getFacade(request, response, session);
                TriggerContext tc = facade.createTriggerContext(request, this.getServletContext());
                RenderingContext rc = facade.createRenderingContext(request, response, this.getServletContext());
                rc.setRendererInfo(RendererInfo.HTML_ALL);
                if (facade.canHandleRequest(tc)) {
                    this.handleTrigger(request, response, facade, rc, tc);
                } else {
                    String actionName = this.getActionFromURI(request);
                    if (null == actionName) {
                        response.sendError(406);
                        return;
                    }
                    Action actionClass = (Action)this._actions.get(actionName);
                    if (null == actionClass) {
                        response.sendError(501);
                        return;
                    }
                    WPage outputPage = actionClass.perform(this, request, response, rc);
                    if (outputPage != null) {
                        IOutput ioOutput;
                        try {
                            ioOutput = outputPage.getOutput(rc);
                            facade.saveAllPages((AContext)rc);
                        }
                        catch (RendererException e) {
                            throw new ServletException("Error getting Frameset output to render.", (Throwable)e);
                        }
                        catch (PageException pe) {
                            throw new ServletException("Error serializing output for Frameset.", (Throwable)pe);
                        }
                        response.setContentType("text/html; charset=UTF-8");
                        if (!response.containsHeader("Pragma")) {
                            response.setHeader("Pragma", "no-cache");
                        }
                        if (!response.containsHeader("Cache-Control")) {
                            response.setHeader("Cache-Control", "no-store");
                        }
                        if (!response.containsHeader("Expires")) {
                            response.setHeader("Expires", "0");
                        }
                        PrintWriter respOut = response.getWriter();
                        try {
                            ((IDocumentOutput)ioOutput).serializeDocument((Writer)respOut);
                        }
                        catch (RendererException e) {
                            throw new ServletException("Error serializing output for Frameset.", (Throwable)e);
                        }
                    }
                    response.setContentType("text/html; charset=UTF-8");
                    response.setStatus(204);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
            throw new ServletException("Error in doGet", (Throwable)e);
        }
        Trace.trace(TRACE_MASKT, "<- ControllerServlet.doGet()");
    }

    private void handleTrigger(HttpServletRequest request, HttpServletResponse response, WclFacade facade, RenderingContext rc, TriggerContext tc) throws ServletException, IOException {
        block15: {
            try {
                IResult result = facade.handleRequest(tc, rc);
                if (result != null) {
                    try {
                        if (result.isResponseHandled()) break block15;
                        IOutput output = result.getOutput(rc);
                        if (output instanceof IDocumentOutput) {
                            response.setContentType("text/html; charset=UTF8");
                            if (!response.containsHeader("Pragma")) {
                                response.setHeader("Pragma", "no-cache");
                            }
                            if (!response.containsHeader("Cache-Control")) {
                                response.setHeader("Cache-Control", "no-store");
                            }
                            if (!response.containsHeader("Expires")) {
                                response.setHeader("Expires", "0");
                            }
                            PrintWriter respOut = response.getWriter();
                            ((IDocumentOutput)output).serializeDocument((Writer)respOut);
                        } else {
                            WComponent comp = result.getComponent();
                            if (comp instanceof WJspPage) {
                                WJspPage page = (WJspPage)comp;
                                String url = page.getURL();
                                ActionUtils.forward((ServletRequest)request, (ServletResponse)response, url);
                            }
                        }
                        break block15;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.out);
                        throw ex;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                        response.sendError(500, "Unexpected exception caught:" + ex.getMessage());
                        break block15;
                    }
                }
                response.sendError(500, "The trigger did not return a result.");
            }
            catch (TriggerException te) {
                UIRefreshManager.refresh(0, HMCSession.getHMCSession(request.getSession()));
            }
            catch (RequestNotHandledException rnhe) {
                rnhe.printStackTrace(System.out);
                throw new ServletException((Throwable)rnhe);
            }
        }
        try {
            facade.saveAllPages((AContext)rc);
        }
        catch (PageException pe) {
            pe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WclFacade getFacade(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        HMCSession hmcSession = HMCSession.getHMCSession(session);
        WclFacade facade = (WclFacade)hmcSession.getHMCCustomScope().getAttribute(FACADE_ID_ATTRIBUTE);
        if (facade == null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                try {
                    ServletContext servletContext = this.getServletContext();
                    if (servletContext.getAttribute(SKIN_MANAGER_ID) == null) {
                        this.createWclObjects(facade, servletContext);
                    }
                    PageManager pm = new PageManager(hmcSession.getHMCCustomScope().getScopeName(), false, false);
                    hmcSession.getHMCCustomScope().setAttribute(PAGE_MANAGER_ID, pm);
                    facade = new WclFacade(TRIGGER_MANAGER_PATH, "s", TRIGGER_MANAGER_ID, "a", RENDERER_FACTORY_ID, "a", SKIN_MANAGER_ID, "s", RESOURCE_LOADER_MANAGER_ID, hmcSession.getHMCCustomScope().getScopeName(), PAGE_MANAGER_ID, hmcSession.getHMCCustomScope().getScopeName(), FRAMERELOAD_MANAGER_ID, null, null);
                }
                catch (HException e) {
                    e.printStackTrace();
                }
                hmcSession.getHMCCustomScope().setAttribute(FACADE_ID_ATTRIBUTE, facade);
            }
        }
        return facade;
    }

    private synchronized void createWclObjects(WclFacade facade, ServletContext servletContext) throws HException {
        Trace.trace(TRACE_MASKF, "Creating heavyweight WCL objects");
        DefaultSkinManager defaultSkinManager = new DefaultSkinManager(false);
        try {
            defaultSkinManager.loadSkins("com/ibm/psw/wcl/core/skin/DefaultSkinManager.xml");
            defaultSkinManager.loadSkins("com/ibm/psw/wcc/skins/DefaultSkinManager.xml");
        }
        catch (Exception ex) {
            Trace.trace(TRACE_MASKT, "DefaultSkinManager: Error occurred trying to load skins = com/ibm/psw/wcl/core/skin/DefaultSkinManager.xml('" + ex.getMessage() + "')");
            Trace.trace(TRACE_MASKT, ex);
            defaultSkinManager = null;
        }
        if (defaultSkinManager == null) {
            defaultSkinManager = new DefaultSkinManager(true);
        }
        servletContext.setAttribute(SKIN_MANAGER_ID, (Object)defaultSkinManager);
        DefaultRendererFactory rendererFactory = null;
        try {
            rendererFactory = new DefaultRendererFactory();
        }
        catch (RendererException e) {
            Trace.trace(TRACE_MASKT, "Error creating global DefaultRendererFactory.");
            if (e instanceof RendererException.EMultipleErrors) {
                Trace.trace(TRACE_MASKT, "Multiple errors recognized:");
                RendererException.EMultipleErrors me = (RendererException.EMultipleErrors)e;
                int count = me.getMessageCount();
                for (int i = 0; i < count; ++i) {
                    Trace.trace(TRACE_MASKT, me.getMessage(i));
                }
            }
            Trace.trace(TRACE_MASKT, (Object)e);
            if (e.getException() != null) {
                Trace.trace(TRACE_MASKT, "The RendererException wrapped this exception");
                Trace.trace(TRACE_MASKT, e.getException());
            }
            throw new HException(e);
        }
        servletContext.setAttribute(RENDERER_FACTORY_ID, (Object)rendererFactory);
    }

    private void createGlobalObjects() throws Exception {
        this.configBean_ = BonsaiConfigDigester.getConfigData();
        uiObjectsReader = new UIObjectsReader();
        TaskManager.init(this.configBean_.getTaskRetrievers());
        BonsaiTreeManager.init(this.configBean_.getNavArea());
        StatusMonitorManager.init(this.configBean_.getStatusMonitors());
    }

    private void initActionClasses(ServletConfig config) throws Exception {
        this._actions = new HashMap();
        String actionName = null;
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            actionName = (String)e.nextElement();
            this._actions.put(actionName, Class.forName(this.getInitParameter(actionName)).newInstance());
        }
    }

    private String getActionFromURI(HttpServletRequest request) {
        String path = request.getServletPath();
        int slash = path.lastIndexOf("/");
        int period = path.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            path = path.substring(0, period);
        }
        return path;
    }

    public static UIObjectsReader getUIObjectsReader() {
        if (uiObjectsReader == null) {
            throw new IllegalStateException("The global reader has not yet been initialized!");
        }
        return uiObjectsReader;
    }

    public WuiConfigBean getConfigBean_() {
        return this.configBean_;
    }
}

